/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* CPCEMU cheat database support code */
#ifndef __CHEAT_DATABASE_HEADER_INCLUDED__
#define __CHEAT_DATABASE_HEADER_INCLUDED__

#include <tchar.h>

#define CHEAT_DATABASE_POKE_ENTRY_FLAGS_ENTER_VALUE 0x001
/*
typedef struct
{
	unsigned char	Flags;
	unsigned long	Addr;
	unsigned char	NewValue;
	unsigned char	OldValue;
} CHEAT_DATABASE_POKE_ENTRY;

typedef struct _CHEAT_DATABASE_ENTRY
{
	struct	_CHEAT_DATABASE_ENTRY *pNext;
	struct	_CHEAT_DATABASE_ENTRY *pPrev;

	unsigned char	*Name;
	unsigned char	*Description;

	unsigned long	NoOfParts;

	unsigned char	Type;

	CHEAT_DATABASE_POKE_ENTRY	Parts[CHEAT_DATABASE_ENTRY_MAX_PARTS];
} CHEAT_DATABASE_ENTRY;

typedef struct
{
	CHEAT_DATABASE_ENTRY	*pFirst;
} CHEAT_DATABASE;

CHEAT_DATABASE *CheatDatabase_Read(const unsigned char *pDataBase, const unsigned long Database_FileLength);
void CheatDatabase_Delete(CHEAT_DATABASE *pDatabase);
void CheatDatabase_Poke(CHEAT_DATABASE_ENTRY *pEntry);
static int CheatDatabase_Parse_PartNumber(void);

CHEAT_DATABASE *CheatDatabase_Parse(const unsigned char *pDatabase, const unsigned long Database_FileLength);
*/
//new one

typedef enum
{
    WINAPE_POKE_DATABASE_TYPE_DECIMAL = 0,
    WINAPE_POKE_DATABASE_TYPE_HEXADECIMAL,
    WINAPE_POKE_DATABASE_TYPE_BCD,
    WINAPE_POKE_DATABASE_TYPE_NUMERIC,          /* Zero based */
    WINAPE_POKE_DATABASE_TYPE_NUMERIC_ASCII,    /* ASCII based */
    WINAPE_POKE_DATABASE_TYPE_LONG,
    WINAPE_POKE_DATABASE_TYPE_STRING
} WINAPE_POKE_DATABASE_TYPE;


static TCHAR *PokType[]=
{
	_T("Decimal"),
	_T("HexaDecimal"),
	_T("BCD"),
	_T("Numeric"),
	_T("Numeric ASCII"),
	_T("Long"),
	_T("String"),
	NULL
};

typedef struct
{
	//address
	unsigned short address;
	//Bytes, pointer list
	unsigned short * byte;
	//nbre of bytes
	int NbrBytes;

 }POKEINFO;

//poke/cheat list by game
typedef struct
{
	//Descripttion
	char Desc[255];
	//Comment
	char Commment[255];
	//Nbre of poke
	int npokes;

	//type of values
	char type;
	//reversed
	BOOL reversed;
	//ram bank
	char ram_bank;

	//poke needed by cheat
	POKEINFO * PokeInfo;

 } POKEINFOBYGAME ;

//Game
typedef struct
{

	//Game name
	char Name[255];
	//Nbre poke
	int NbrePoke;
	//pokes info
	POKEINFOBYGAME *PokeInfoByGame;

 }POKEGAMEINFO;


BOOL WinapePokeDatabaseInit(const char *pWinapePokeDatabase, long size);
void WinapePokeDatabase_ApplyPoke(int nGame, int nPoke, const char *pPoke);
void WinapePokeDatabase_Free(void);

int GetNumberGame(void);
BOOL GetNameofGame(int i, char *Name);
BOOL CheatSetGame(int id);
void ClearGamePoke(void);
BOOL ApplyPoke(char *data,long Address);
BOOL LoadDatabase(char *file);
int SearchGameinMemory(void);

long NumericChain(char *str);

#endif
